
#property indicator_separate_window
#property indicator_buffers 12
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrLimeGreen
#property indicator_color3  clrRed
#property indicator_color4  clrRed
#property indicator_color5  clrDimGray
#property indicator_color6  clrKhaki
#property indicator_style2  STYLE_DOT
#property indicator_style3  STYLE_DOT
#property indicator_style5  STYLE_DOT
#property strict

//
//
//
//
//

#import "dynamicZone.dll"
   double dzBuyP(double& sourceArray[],double probabiltyValue, int lookBack, int bars, int i, double precision);
   double dzSellP(double& sourceArray[],double probabiltyValue, int lookBack, int bars, int i, double precision);
#import

//
//
//
//
//

extern int                Length                  = 14;                // Rsx length
extern ENUM_APPLIED_PRICE Price                   = PRICE_TYPICAL;     // Rsx price
extern int                DzLookBackBars          = 70;                // DZ lookback bars
extern double             DzStartBuyProbability1  = 0.10;              // DZ start buy probality 1
extern double             DzStartBuyProbability2  = 0.25;              // DZ start buy probality 2
extern double             DzStartSellProbability1 = 0.10;              // DZ start sell probality 1
extern double             DzStartSellProbability2 = 0.25;              // DZ start sell probality 2
extern bool               alertsOn                = false;             // Turn alerts on?
extern bool               alertsOnCurrent         = false;             // Alerts on still opened bar?
extern bool               alertsMessage           = true;              // Alerts should display message?
extern bool               alertsSound             = false;             // Alerts should play a sound?
extern bool               alertsNotify            = false;             // Alerts should send a notification?
extern bool               alertsEmail             = false;             // Alerts should send an email?
extern string             soundFile               = "alert2.wav";      // Sound file
extern color              ColorUp                 = clrLimeGreen;      // Color for up
extern color              ColorDown               = clrRed;            // Color for down
extern color              ShadowColor             = clrGray;           // Shadow color
extern int                LineWidth               = 3;                 // Main line width
extern int                ShadowWidth             = 0;                 // Shadow width (<=0 main line width+3) 

//
//
//
//
//

double rsx[],bl1Buffer[],bl2Buffer[],sl1Buffer[],sl2Buffer[],zliBuffer[],buffer1da[],buffer1db[],buffer1ua[],buffer1ub[],shadowa[],shadowb[],trend[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

int init()
{
   int shadowWidth = (ShadowWidth<=0) ? LineWidth+3 : ShadowWidth;
   IndicatorBuffers(13);
   SetIndexBuffer(0, bl1Buffer);
   SetIndexBuffer(1, bl2Buffer);
   SetIndexBuffer(2, sl2Buffer);
   SetIndexBuffer(3, sl1Buffer);
   SetIndexBuffer(4, zliBuffer);
   SetIndexBuffer(5, rsx);       SetIndexStyle(5, EMPTY,EMPTY,LineWidth);
   SetIndexBuffer(6, shadowa);   SetIndexStyle(6, EMPTY,EMPTY,shadowWidth,ShadowColor);
   SetIndexBuffer(7, shadowb);   SetIndexStyle(7, EMPTY,EMPTY,shadowWidth,ShadowColor);
   SetIndexBuffer(8, buffer1ua); SetIndexStyle(8, EMPTY,EMPTY,LineWidth,ColorUp);
   SetIndexBuffer(9, buffer1ub); SetIndexStyle(9, EMPTY,EMPTY,LineWidth,ColorUp);
   SetIndexBuffer(10,buffer1da); SetIndexStyle(10,EMPTY,EMPTY,LineWidth,ColorDown);
   SetIndexBuffer(11,buffer1db); SetIndexStyle(11,EMPTY,EMPTY,LineWidth,ColorDown);
   SetIndexBuffer(12,trend);
   
   IndicatorShortName("Double dynamic Rsx ("+(string)Length+")");
   
return(0);
}
int deinit() {  return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//


double wrkBuffer[][13];
int start()
{
   int counted_bars=IndicatorCounted();
   int i,r,limit;
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         if (ArrayRange(wrkBuffer,0) != Bars) ArrayResize(wrkBuffer,Bars);

   //
   //
   //
   //
   //
  
   double Kg = (3.0)/(2.0+Length); 
   double Hg = 1.0-Kg;
   if (trend[limit]==-1) { CleanPoint(limit,buffer1da,buffer1db); CleanPoint(limit,shadowa,shadowb); }
   if (trend[limit]== 1) { CleanPoint(limit,buffer1ua,buffer1ub); CleanPoint(limit,shadowa,shadowb); }
   for(i=limit, r=Bars-i-1; i>=0; i--, r++)
   {
      wrkBuffer[r][12] = iMA(NULL,0,1,0,MODE_SMA,Price,i);
      if (i==(Bars-1)) { for (int c=0; c<12; c++) wrkBuffer[r][c] = 0; continue; }  

      //
      //
      //
      //
      //
      
      double mom = wrkBuffer[r][12]-wrkBuffer[r-1][12];
      double moa = MathAbs(mom);
      for (int k=0; k<3; k++)
      {
         int kk = k*2;
            wrkBuffer[r][kk+0] = Kg*mom                + Hg*wrkBuffer[r-1][kk+0];
            wrkBuffer[r][kk+1] = Kg*wrkBuffer[r][kk+0] + Hg*wrkBuffer[r-1][kk+1]; mom = 1.5*wrkBuffer[r][kk+0] - 0.5 * wrkBuffer[r][kk+1];
            wrkBuffer[r][kk+6] = Kg*moa                + Hg*wrkBuffer[r-1][kk+6];
            wrkBuffer[r][kk+7] = Kg*wrkBuffer[r][kk+6] + Hg*wrkBuffer[r-1][kk+7]; moa = 1.5*wrkBuffer[r][kk+6] - 0.5 * wrkBuffer[r][kk+7];
      }
      if (moa != 0)
           rsx[i] = MathMax(MathMin((mom/moa+1.0)*50.0,100.00),0.00); 
      else rsx[i] = 50.0;
      
      if (DzStartBuyProbability1 >0) bl1Buffer[i] = dzBuyP (rsx, DzStartBuyProbability1,  DzLookBackBars, Bars, i, 0.0001);
      if (DzStartBuyProbability2 >0) bl2Buffer[i] = dzBuyP (rsx, DzStartBuyProbability2,  DzLookBackBars, Bars, i, 0.0001);
      if (DzStartSellProbability1>0) sl1Buffer[i] = dzSellP(rsx, DzStartSellProbability1, DzLookBackBars, Bars, i, 0.0001);
      if (DzStartSellProbability2>0) sl2Buffer[i] = dzSellP(rsx, DzStartSellProbability2, DzLookBackBars, Bars, i, 0.0001);
                                     zliBuffer[i] = dzSellP(rsx, 0.5                    , DzLookBackBars, Bars, i, 0.0001);
       buffer1da[i] = EMPTY_VALUE;
       buffer1db[i] = EMPTY_VALUE;
       buffer1ua[i] = EMPTY_VALUE;
       buffer1ub[i] = EMPTY_VALUE;
       shadowa[i]   = EMPTY_VALUE;
       shadowb[i]   = EMPTY_VALUE;                            
                                     
       trend[i] = (rsx[i]<bl1Buffer[i]) ? 1 : (rsx[i]>sl1Buffer[i]) ? -1 :  0;                              
       if (trend[i] == -1) { PlotPoint(i,buffer1da,buffer1db,rsx); PlotPoint(i,shadowa,shadowb,rsx); }
       if (trend[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,rsx); PlotPoint(i,shadowa,shadowb,rsx); }      
   }
manageAlerts();
return(0);
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                          second[i] = EMPTY_VALUE; }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] == 1) doAlert(whichBar," crossing below");
         if (trend[whichBar] ==-1) doAlert(whichBar," crossing above");
      }         
   }
}   

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //
       
       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," DDZ Rsx ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" DDZ Rsx ",message);
          if (alertsSound)   PlaySound(soundFile);
       
   }
}


   
   